/** @file   LightBeamCell.h
 * @brief   Declaration of LightBeamCell class
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/06/17 21:44:40 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_LIGHTBEAMCELL_H
#define H_WWW_LIGHTBEAMCELL_H

#include "eng2d.h"


namespace WeWantWar {

class MMapAccessInterface;


/** @class  LightBeamCell
 * @brief   Represents a single element that is used to produce lightbeams
 * @author  Tomi Lamminsaari
 */   
class LightBeamCell
{
public:
    /** Constructor.
     * @param   aPos            Position of this light beam cell
     * @param   aBrightness     Original brightness
     * @param   aCellSize       Size of this lightbeam cell
     */
    LightBeamCell( const eng2d::Vec2D& aPos, float aBrightness, float aCellSize,
                   int aColor );
     
    /** Destructor.
     */
    ~LightBeamCell();
    
    /** Updates the brightness values of this lightbeam cell.
     * @param   aOrigin         The center of the lightsource in world coordinates
     * @param   aMapAccess      Reference to object that provides the map data
     * @param   aDirection      Heading direction of the beam.
     */
    void update( const eng2d::Vec2D& aOrigin, const MMapAccessInterface& aMapAccess, float aDirection );
       
    /** Renders this lightcell to given mask bitmap.
     * @param   aCanvas         Pointer to target bitmap.
     * @param   aOrigin         Center coordinate on the bitmap.
     */
    void renderBrightness( BITMAP* aCanvas, const eng2d::Vec2D& aOrigin ) const;
    
    /** Returns the relative position of this cell.
     * @return  Position of this cell.
     */
    eng2d::Vec2D cellPosition() const;
    
private:
    /** Relative position of this cell. */
    eng2d::Vec2D iPosition;
    /** The original brightness of this cell. */
    float iOriginalBrightness;
    int iOriginalColor;
    int iDynamicColor;
    /** Size of this cell. */
    float iCellSize;
    /** Dynamic brightness value. */
    float iDynamicBrightness;
};

};  // end of namespace

#endif
